/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.rustable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_5547;
import net.minecraft.class_5819;

public interface Rustable
extends class_5547<RustLevel> {
    public static final Supplier<BiMap<class_2248, class_2248>> RUST_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)ModBlocks.CUT_IRON.get(), (Object)ModBlocks.EXPOSED_CUT_IRON.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON.get(), (Object)ModBlocks.WEATHERED_CUT_IRON.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON.get(), (Object)ModBlocks.RUSTED_CUT_IRON.get()).put((Object)ModBlocks.CUT_IRON_SLAB.get(), (Object)ModBlocks.EXPOSED_CUT_IRON_SLAB.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON_SLAB.get(), (Object)ModBlocks.WEATHERED_CUT_IRON_SLAB.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON_SLAB.get(), (Object)ModBlocks.RUSTED_CUT_IRON_SLAB.get()).put((Object)ModBlocks.CUT_IRON_STAIRS.get(), (Object)ModBlocks.EXPOSED_CUT_IRON_STAIRS.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON_STAIRS.get(), (Object)ModBlocks.WEATHERED_CUT_IRON_STAIRS.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON_STAIRS.get(), (Object)ModBlocks.RUSTED_CUT_IRON_STAIRS.get()).put((Object)ModBlocks.PLATE_IRON.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON.get(), (Object)ModBlocks.RUSTED_PLATE_IRON.get()).put((Object)ModBlocks.PLATE_IRON_SLAB.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON_SLAB.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON_SLAB.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON_SLAB.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON_SLAB.get(), (Object)ModBlocks.RUSTED_PLATE_IRON_SLAB.get()).put((Object)ModBlocks.PLATE_IRON_STAIRS.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON_STAIRS.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON_STAIRS.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON_STAIRS.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON_STAIRS.get(), (Object)ModBlocks.RUSTED_PLATE_IRON_STAIRS.get()).put((Object)class_2246.field_9973, (Object)ModBlocks.EXPOSED_IRON_DOOR.get()).put((Object)ModBlocks.EXPOSED_IRON_DOOR.get(), (Object)ModBlocks.WEATHERED_IRON_DOOR.get()).put((Object)ModBlocks.WEATHERED_IRON_DOOR.get(), (Object)ModBlocks.RUSTED_IRON_DOOR.get()).put((Object)class_2246.field_10453, (Object)ModBlocks.EXPOSED_IRON_TRAPDOOR.get()).put((Object)ModBlocks.EXPOSED_IRON_TRAPDOOR.get(), (Object)ModBlocks.WEATHERED_IRON_TRAPDOOR.get()).put((Object)ModBlocks.WEATHERED_IRON_TRAPDOOR.get(), (Object)ModBlocks.RUSTED_IRON_TRAPDOOR.get()).put((Object)class_2246.field_10576, (Object)ModBlocks.EXPOSED_IRON_BARS.get()).put((Object)ModBlocks.EXPOSED_IRON_BARS.get(), (Object)ModBlocks.WEATHERED_IRON_BARS.get()).put((Object)ModBlocks.WEATHERED_IRON_BARS.get(), (Object)ModBlocks.RUSTED_IRON_BARS.get()).put((Object)ModBlocks.CUT_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.EXPOSED_CUT_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.WEATHERED_CUT_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.RUSTED_CUT_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.PLATE_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.RUSTED_PLATE_IRON_VERTICAL_SLAB.get()).build());
    public static final Supplier<BiMap<class_2248, class_2248>> RUST_LEVEL_DECREASES = Suppliers.memoize(() -> RUST_LEVEL_INCREASES.get().inverse());

    public static Optional<class_2248> getDecreasedRustBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)RUST_LEVEL_DECREASES.get().get((Object)block));
    }

    public static class_2248 getUnaffectedRustBlock(class_2248 block) {
        class_2248 block2 = block;
        class_2248 block3 = (class_2248)RUST_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (class_2248)RUST_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2;
    }

    default public Optional<class_2680> getPrevious(class_2680 state) {
        return Rustable.getDecreasedRustBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2248> getIncreasedRustBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)RUST_LEVEL_INCREASES.get().get((Object)block));
    }

    public static class_2680 getUnaffectedRustState(class_2680 state) {
        return Rustable.getUnaffectedRustBlock(state.method_26204()).method_34725(state);
    }

    default public Optional<class_2680> method_31639(class_2680 state) {
        return Rustable.getIncreasedRustBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    default public float method_33620() {
        if (this.method_33622() == RustLevel.UNAFFECTED) {
            return 0.75f;
        }
        return 1.0f;
    }

    default public int getInfluenceRadius() {
        return CommonConfigs.RUSTING_INFLUENCE_RADIUS.get();
    }

    default public void method_33623(class_2680 state, class_3218 serverLevel, class_2338 pos, class_5819 randomSource) {
        class_2338 blockpos;
        int distance;
        int age = ((RustLevel)this.method_33622()).ordinal();
        int j = 0;
        int k = 0;
        int affectingDistance = this.getInfluenceRadius();
        Iterator iterator = class_2338.method_25996((class_2338)pos, (int)affectingDistance, (int)affectingDistance, (int)affectingDistance).iterator();
        while (iterator.hasNext() && (distance = (blockpos = (class_2338)iterator.next()).method_19455((class_2382)pos)) <= affectingDistance) {
            class_2680 blockstate;
            class_2248 block;
            if (blockpos.equals((Object)pos) || !((block = (blockstate = serverLevel.method_8320(blockpos)).method_26204()) instanceof class_5547)) continue;
            class_5547 changeOverTimeBlock = (class_5547)block;
            Enum ageEnum = changeOverTimeBlock.method_33622();
            if (((Object)((Object)((RustLevel)this.method_33622()))).getClass() != ageEnum.getClass()) continue;
            int neighbourAge = ageEnum.ordinal();
            if (neighbourAge < age) {
                return;
            }
            if (neighbourAge > age) {
                ++k;
                continue;
            }
            ++j;
        }
        float f = (float)(k + 1) / (float)(k + j + 1);
        float f1 = f * f * this.method_33620();
        if (randomSource.method_43057() < f1) {
            this.method_31639(state).ifPresent(s -> serverLevel.method_8501(pos, s));
        }
    }

    default public void tryWeather(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26164(ModTags.RUSTED_IRON)) {
            boolean canWeather = false;
            for (class_2350 direction : class_2350.values()) {
                class_2338 targetPos = pos.method_10093(direction);
                class_2680 neighborState = world.method_8320(targetPos);
                if (neighborState.method_27852(class_2246.field_10422) && (double)random.method_43057() < CommonConfigs.RUSTING_RATE.get()) {
                    canWeather = true;
                    continue;
                }
                if (neighborState.method_26227().method_15767(class_3486.field_15517) && (double)random.method_43057() < CommonConfigs.RUSTING_RATE.get() / 1.25) {
                    canWeather = true;
                    continue;
                }
                if (state.method_26164(ModTags.CLEAN_IRON)) {
                    if (!neighborState.method_27852(class_2246.field_10124) || !((double)random.method_43057() < CommonConfigs.RUSTING_RATE.get() / 5.0)) continue;
                    canWeather = true;
                    continue;
                }
                if (!state.method_26164(ModTags.EXPOSED_IRON) && (!state.method_26164(ModTags.CLEAN_IRON) || !world.method_8419() || !((double)random.method_43057() < CommonConfigs.RUSTING_RATE.get() / 2.0))) continue;
                if (world.method_8520(pos.method_10084())) {
                    canWeather = true;
                    continue;
                }
                if (!CommonConfigs.RUST_STREAKING.get().booleanValue() || !world.method_8520(targetPos) || !world.method_8320(pos.method_10084()).method_26164(ModTags.WEATHERED_IRON) || !((double)random.method_43057() < CommonConfigs.RUSTING_RATE.get() / 3.0)) continue;
                if (class_2338.method_25998((class_2338)pos, (int)2, (int)2, (int)2).map(arg_0 -> ((class_3218)world).method_8320(arg_0)).filter(b -> b.method_26164(ModTags.WEATHERED_IRON)).toList().size() > 9) continue;
                canWeather = true;
            }
            if (canWeather) {
                this.method_33623(state, world, pos, random);
            }
        }
    }

    public static enum RustLevel {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        RUSTED;


        public boolean canScrape() {
            return this != WEATHERED && this != RUSTED;
        }
    }
}

